/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.items.ItemLoader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;

public class TileEntityPainting
extends TileEntity
implements IInventory {
    private ItemStack[] inventory = new ItemStack[1];
    public int angle;
    public int frameStyle;
    public int paintingType = 0;
    public String paintingTitle = "blank";
    public int paintingRotation = 0;
    public int paintingMasterCorner = 0;
    public int paintingScale = 1;
    public int paintingAspectRatio = 0;
    public int paintingPixelRes = 0;
    public int customPaintingAspectX = 1;
    public int customPaintingAspectY = 1;
    public boolean connectedTop = false;
    public boolean connectedLeft = false;
    public boolean connectedBottom = false;
    public boolean connectedRight = false;
    public boolean showTLCorner = true;
    public boolean showTRCorner = true;
    public boolean showBRCorner = true;
    public boolean showBLCorner = true;
    public boolean containerUpdate = false;
    public boolean islocked = false;
    public String lockee = "";
    public boolean hideFrame;
    public String customTex = "none";
    public ResourceLocation customTexture = null;

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        double distance = Config.renderDistancePainting;
        return distance * distance;
    }

    public void setCustomTex(String tex) {
        this.customTex = tex;
        this.customTexture = tex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ResourceLocation getCustomTex() {
        if (this.customTexture != null) {
            return this.customTexture;
        }
        return CommonProxy.PLANKSOAK;
    }

    public String getCustomTexString() {
        return this.customTex;
    }

    public void setHideFrame(boolean hide) {
        this.hideFrame = hide;
    }

    public boolean getHideFrame() {
        return this.hideFrame;
    }

    public void setAngle(int ang) {
        this.angle = ang;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isLocked() {
        return this.islocked;
    }

    public void setLocked(boolean locked) {
        this.islocked = locked;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String getLockee() {
        return this.lockee;
    }

    public void setLockee(String lockeeperson) {
        this.lockee = lockeeperson;
    }

    public void setFrameStyle(int style) {
        this.frameStyle = style;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setConnectTop(boolean connect) {
        this.connectedTop = connect;
        this.checkDiagnoalsForCorners(true);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setConnectLeft(boolean connect) {
        this.connectedLeft = connect;
        this.checkDiagnoalsForCorners(true);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setConnectBottom(boolean connect) {
        this.connectedBottom = connect;
        this.checkDiagnoalsForCorners(true);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setConnectRight(boolean connect) {
        this.connectedRight = connect;
        this.checkDiagnoalsForCorners(true);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setPaintingRotation(int rot) {
        this.paintingRotation = rot;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setPacketUpdate(int corner, int scale, int pixels, int aspect, int rotation, int aspectX, int aspectY) {
        this.paintingMasterCorner = corner;
        this.paintingScale = scale;
        this.paintingPixelRes = pixels;
        this.paintingAspectRatio = aspect;
        this.paintingRotation = rotation;
        this.customPaintingAspectX = aspectX;
        this.customPaintingAspectY = aspectY;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setPacketAspectsUpdate(int aspectX, int aspectY) {
        this.customPaintingAspectX = aspectX;
        this.customPaintingAspectY = aspectY;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setContainterUpdate(boolean update) {
        this.containerUpdate = update;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean getContainerUpdate() {
        return this.containerUpdate;
    }

    public int getCustomPaintingAspectX() {
        return this.customPaintingAspectX;
    }

    public int getCustomPaintingAspectY() {
        return this.customPaintingAspectY;
    }

    public void resetPaintingData() {
        this.paintingRotation = 0;
        this.paintingMasterCorner = 0;
        this.paintingScale = 1;
        this.paintingAspectRatio = 0;
        this.paintingPixelRes = 0;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void checkDiagnoalsForCorners(boolean checkFurtherPaintings) {
        TileEntityPainting paintTile;
        TileEntity topLeftdiagTile = null;
        TileEntity topRightdiagTile = null;
        TileEntity bottomRightdiagTile = null;
        TileEntity bottomLeftdiagTile = null;
        switch (this.angle) {
            case 0: {
                topLeftdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1);
                topRightdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1);
                bottomRightdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1);
                bottomLeftdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1);
                break;
            }
            case 1: {
                topLeftdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e);
                topRightdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e);
                bottomRightdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e);
                bottomLeftdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e);
                break;
            }
            case 2: {
                topLeftdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1);
                topRightdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1);
                bottomRightdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1);
                bottomLeftdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1);
                break;
            }
            case 3: {
                topLeftdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e);
                topRightdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e);
                bottomRightdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e);
                bottomLeftdiagTile = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e);
            }
        }
        this.showTLCorner = true;
        this.showTRCorner = true;
        this.showBRCorner = true;
        this.showBLCorner = true;
        if (topLeftdiagTile != null && topLeftdiagTile instanceof TileEntityPainting && (paintTile = (TileEntityPainting)topLeftdiagTile).getConnectBottom() && paintTile.getConnectRight()) {
            this.showTLCorner = false;
            if (checkFurtherPaintings) {
                paintTile.checkDiagnoalsForCorners(false);
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            paintTile.updateLocalPaintings();
        }
        if (topRightdiagTile != null && topRightdiagTile instanceof TileEntityPainting && (paintTile = (TileEntityPainting)topRightdiagTile).getConnectBottom() && paintTile.getConnectLeft()) {
            this.showTRCorner = false;
            if (checkFurtherPaintings) {
                paintTile.checkDiagnoalsForCorners(false);
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            paintTile.updateLocalPaintings();
        }
        if (bottomRightdiagTile != null && bottomRightdiagTile instanceof TileEntityPainting && (paintTile = (TileEntityPainting)bottomRightdiagTile).getConnectTop() && paintTile.getConnectLeft()) {
            this.showBRCorner = false;
            if (checkFurtherPaintings) {
                paintTile.checkDiagnoalsForCorners(false);
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            paintTile.updateLocalPaintings();
        }
        if (bottomLeftdiagTile != null && bottomLeftdiagTile instanceof TileEntityPainting && (paintTile = (TileEntityPainting)bottomLeftdiagTile).getConnectTop() && paintTile.getConnectRight()) {
            this.showBLCorner = false;
            if (checkFurtherPaintings) {
                paintTile.checkDiagnoalsForCorners(false);
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            paintTile.updateLocalPaintings();
        }
    }

    public void updateLocalPaintings() {
        TileEntityPainting tile;
        TileEntity topTile = null;
        TileEntity bottomTile = null;
        TileEntity rightTile = null;
        TileEntity leftTile = null;
        switch (this.angle) {
            case 0: {
                topTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                bottomTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                rightTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                leftTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                break;
            }
            case 1: {
                topTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                bottomTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                rightTile = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                leftTile = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 2: {
                topTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                bottomTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                rightTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                leftTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                break;
            }
            case 3: {
                topTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                bottomTile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                rightTile = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                leftTile = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            }
        }
        if (topTile != null && topTile instanceof TileEntityPainting) {
            tile = (TileEntityPainting)topTile;
            tile.updateMe();
        }
        if (bottomTile != null && bottomTile instanceof TileEntityPainting) {
            tile = (TileEntityPainting)bottomTile;
            tile.updateMe();
        }
        if (rightTile != null && rightTile instanceof TileEntityPainting) {
            tile = (TileEntityPainting)rightTile;
            tile.updateMe();
        }
        if (leftTile != null && leftTile instanceof TileEntityPainting) {
            tile = (TileEntityPainting)leftTile;
            tile.updateMe();
        }
    }

    public void updateMe() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void sendUpdateNotify() {
        if (this.angle == 0 || this.angle == 2) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1, BlockLoader.paintingBorderless);
            this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1, BlockLoader.paintingBorderless);
            this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1, BlockLoader.paintingBorderless);
            this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1, BlockLoader.paintingBorderless);
        } else {
            this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e, BlockLoader.paintingBorderless);
            this.field_145850_b.func_147460_e(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e, BlockLoader.paintingBorderless);
            this.field_145850_b.func_147460_e(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e, BlockLoader.paintingBorderless);
            this.field_145850_b.func_147460_e(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e, BlockLoader.paintingBorderless);
        }
    }

    public boolean getConnectTop() {
        return this.connectedTop;
    }

    public boolean getConnectLeft() {
        return this.connectedLeft;
    }

    public boolean getConnectBottom() {
        return this.connectedBottom;
    }

    public boolean getConnectRight() {
        return this.connectedRight;
    }

    public boolean getShowTLCorner() {
        return this.showTLCorner;
    }

    public boolean getShowTRCorner() {
        return this.showTRCorner;
    }

    public boolean getShowBRCorner() {
        return this.showBRCorner;
    }

    public boolean getShowBLCorner() {
        return this.showBLCorner;
    }

    public int getPaintingRotation() {
        return this.paintingRotation;
    }

    public int getAngle() {
        return this.angle;
    }

    public int getFrameStyle() {
        return this.frameStyle;
    }

    public int getPaintingCorner() {
        return this.paintingMasterCorner;
    }

    public int getPaintingScale() {
        return this.paintingScale;
    }

    public int getPaintingRes() {
        return this.paintingPixelRes;
    }

    public int getPaintingAspectRatio() {
        return this.paintingAspectRatio;
    }

    public boolean hasPainting() {
        return this.func_70301_a(0) != null;
    }

    public int getPaintingType() {
        return this.paintingType;
    }

    public String getPaintingTitle() {
        return this.paintingTitle;
    }

    public int addPainting(ItemStack stack) {
        if (stack == null) {
            this.func_70299_a(0, null);
            return -1;
        }
        ItemStack currentCanvas = this.func_70301_a(0);
        if (currentCanvas == null) {
            this.resetPaintingData();
            ItemStack newCanvas = stack.func_77946_l();
            if (stack.field_77994_a > 1) {
                newCanvas.field_77994_a = 1;
                this.func_70299_a(0, newCanvas);
                return stack.field_77994_a - 1;
            }
            this.func_70299_a(0, newCanvas);
            return 0;
        }
        return -1;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        NBTTagCompound tags;
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (stack != null && stack.func_77973_b() == ItemLoader.paintingCanvas && (tags = stack.func_77978_p()) != null) {
            this.paintingTitle = tags.func_74779_i("paintingTitle");
            this.paintingType = tags.func_74762_e("paintingType");
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        Item stackSizeTest = stack.func_77973_b();
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public int func_70297_j_() {
        return 1;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList tagList = nbt.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.angle = nbt.func_74762_e("angle");
        this.paintingType = nbt.func_74762_e("paintingType");
        this.paintingTitle = nbt.func_74779_i("paintingTitle");
        this.frameStyle = nbt.func_74762_e("frameStyle");
        this.connectedTop = nbt.func_74767_n("connectedTop");
        this.connectedLeft = nbt.func_74767_n("connectedLeft");
        this.connectedBottom = nbt.func_74767_n("connectedBottom");
        this.connectedRight = nbt.func_74767_n("connectedRight");
        this.paintingRotation = nbt.func_74762_e("paintingRotation");
        this.showTLCorner = nbt.func_74767_n("showTLCorner");
        this.showTRCorner = nbt.func_74767_n("showTRCorner");
        this.showBRCorner = nbt.func_74767_n("showBRCorner");
        this.showBLCorner = nbt.func_74767_n("showBLCorner");
        this.paintingMasterCorner = nbt.func_74762_e("masterCorner");
        this.paintingScale = nbt.func_74762_e("paintingScale");
        this.paintingPixelRes = nbt.func_74762_e("paintingPixelRes");
        this.paintingAspectRatio = nbt.func_74762_e("paintingAspectRatio");
        this.customPaintingAspectX = nbt.func_74762_e("customPaintingAspectX");
        this.customPaintingAspectY = nbt.func_74762_e("customPaintingAspectY");
        this.islocked = nbt.func_74767_n("locked");
        this.lockee = nbt.func_74779_i("lockee");
        this.hideFrame = nbt.func_74767_n("hideFrame");
        this.customTex = nbt.func_74779_i("customTexture");
        this.customTexture = this.customTex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Inventory", (NBTBase)itemList);
        nbt.func_74768_a("angle", this.angle);
        nbt.func_74768_a("paintingType", this.paintingType);
        nbt.func_74778_a("paintingTitle", this.paintingTitle);
        nbt.func_74768_a("frameStyle", this.frameStyle);
        nbt.func_74757_a("connectedTop", this.connectedTop);
        nbt.func_74757_a("connectedLeft", this.connectedLeft);
        nbt.func_74757_a("connectedBottom", this.connectedBottom);
        nbt.func_74757_a("connectedRight", this.connectedRight);
        nbt.func_74768_a("paintingRotation", this.paintingRotation);
        nbt.func_74757_a("showTLCorner", this.showTLCorner);
        nbt.func_74757_a("showTRCorner", this.showTRCorner);
        nbt.func_74757_a("showBRCorner", this.showBRCorner);
        nbt.func_74757_a("showBLCorner", this.showBLCorner);
        nbt.func_74768_a("masterCorner", this.paintingMasterCorner);
        nbt.func_74768_a("paintingScale", this.paintingScale);
        nbt.func_74768_a("paintingPixelRes", this.paintingPixelRes);
        nbt.func_74768_a("paintingAspectRatio", this.paintingAspectRatio);
        nbt.func_74768_a("customPaintingAspectX", this.customPaintingAspectX);
        nbt.func_74768_a("customPaintingAspectY", this.customPaintingAspectY);
        nbt.func_74757_a("locked", this.islocked);
        nbt.func_74778_a("lockee", this.lockee);
        nbt.func_74757_a("hideFrame", this.hideFrame);
        nbt.func_74778_a("customTexture", this.customTex);
    }

    public Packet func_145844_m() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74768_a("angle", this.angle);
        dataTag.func_74768_a("paintingType", this.paintingType);
        dataTag.func_74778_a("paintingTitle", this.paintingTitle);
        dataTag.func_74768_a("frameStyle", this.frameStyle);
        dataTag.func_74757_a("connectedTop", this.connectedTop);
        dataTag.func_74757_a("connectedLeft", this.connectedLeft);
        dataTag.func_74757_a("connectedBottom", this.connectedBottom);
        dataTag.func_74757_a("connectedRight", this.connectedRight);
        dataTag.func_74768_a("paintingRotation", this.paintingRotation);
        dataTag.func_74757_a("showTLCorner", this.showTLCorner);
        dataTag.func_74757_a("showTRCorner", this.showTRCorner);
        dataTag.func_74757_a("showBRCorner", this.showBRCorner);
        dataTag.func_74757_a("showBLCorner", this.showBLCorner);
        dataTag.func_74768_a("masterCorner", this.paintingMasterCorner);
        dataTag.func_74768_a("paintingScale", this.paintingScale);
        dataTag.func_74768_a("paintingPixelRes", this.paintingPixelRes);
        dataTag.func_74768_a("paintingAspectRatio", this.paintingAspectRatio);
        dataTag.func_74768_a("customPaintingAspectX", this.customPaintingAspectX);
        dataTag.func_74768_a("customPaintingAspectY", this.customPaintingAspectY);
        dataTag.func_74757_a("containerUpdate", this.containerUpdate);
        dataTag.func_74757_a("locked", this.islocked);
        dataTag.func_74778_a("lockee", this.lockee);
        dataTag.func_74757_a("hideFrame", this.hideFrame);
        dataTag.func_74778_a("customTexture", this.customTex);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        dataTag.func_74782_a("inventory", (NBTBase)itemList);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, dataTag);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbtData = packet.func_148857_g();
        this.angle = nbtData.func_74762_e("angle");
        this.paintingType = nbtData.func_74762_e("paintingType");
        this.paintingTitle = nbtData.func_74779_i("paintingTitle");
        this.frameStyle = nbtData.func_74762_e("frameStyle");
        this.connectedTop = nbtData.func_74767_n("connectedTop");
        this.connectedLeft = nbtData.func_74767_n("connectedLeft");
        this.connectedBottom = nbtData.func_74767_n("connectedBottom");
        this.connectedRight = nbtData.func_74767_n("connectedRight");
        this.paintingRotation = nbtData.func_74762_e("paintingRotation");
        this.showTLCorner = nbtData.func_74767_n("showTLCorner");
        this.showTRCorner = nbtData.func_74767_n("showTRCorner");
        this.showBRCorner = nbtData.func_74767_n("showBRCorner");
        this.showBLCorner = nbtData.func_74767_n("showBLCorner");
        this.paintingMasterCorner = nbtData.func_74762_e("masterCorner");
        this.paintingScale = nbtData.func_74762_e("paintingScale");
        this.paintingPixelRes = nbtData.func_74762_e("paintingPixelRes");
        this.paintingAspectRatio = nbtData.func_74762_e("paintingAspectRatio");
        this.customPaintingAspectX = nbtData.func_74762_e("customPaintingAspectX");
        this.customPaintingAspectY = nbtData.func_74762_e("customPaintingAspectY");
        this.containerUpdate = nbtData.func_74767_n("containerUpdate");
        this.islocked = nbtData.func_74767_n("locked");
        this.lockee = nbtData.func_74779_i("lockee");
        this.hideFrame = nbtData.func_74767_n("hideFrame");
        this.customTex = nbtData.func_74779_i("customTexture");
        this.customTexture = this.customTex.contentEquals("none") ? null : BiblioRenderHelper.getBlockResource(this.customTex);
        NBTTagList tagList = nbtData.func_150295_c("inventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3 - this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_145848_d - 3 - this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_145849_e - 3 - this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_145851_c + 4 + this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_145848_d + 4 + this.paintingScale * (this.paintingAspectRatio + 1)), (double)(this.field_145849_e + 4 + this.paintingScale * (this.paintingAspectRatio + 1)));
        return bb;
    }

    public String func_145825_b() {
        return "jds.tileentitypainting";
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        Item stackitem = itemstack.func_77973_b();
        return stackitem != null && stackitem == ItemLoader.paintingCanvas;
    }
}

